/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.threads;

import dangerzone.Coords;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.blocks.Blocks;
import dangerzone.world.Chunk;
import dangerzone.world.World;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LightingThread
implements Runnable {
    public int tickmax = 14;
    public static List<Coords> requested_list;
    public static Lock requested_list_lock;

    static {
        requested_list_lock = new ReentrantLock();
    }

    public LightingThread() {
        requested_list = new ArrayList<Coords>();
    }

    @Override
    public void run() {
        boolean restart = false;
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Thread thisthread = Thread.currentThread();
        thisthread.setPriority(1);
        int currentdimension = DangerZone.player.dimension;
        while (DangerZone.gameover == 0) {
            this.tickmax = DangerZone.renderdistance;
            int i = -this.tickmax;
            while (i <= this.tickmax && DangerZone.gameover == 0 && !restart) {
                int j = -this.tickmax;
                while (j <= this.tickmax && DangerZone.gameover == 0 && !restart) {
                    int chance;
                    if (!((int)Math.sqrt(i * i + j * j) > this.tickmax || Math.sqrt(chance = i * i + j * j) > (double)(DangerZone.renderdistance / 4) && DangerZone.world.rand.nextInt(chance + 2) != 0)) {
                        if (!DangerZone.f12_on) {
                            this.tickChunk(DangerZone.world, i, j);
                        }
                        if (currentdimension != DangerZone.player.dimension) {
                            currentdimension = DangerZone.player.dimension;
                            restart = true;
                        }
                        try {
                            long sleeper = 2L;
                            sleeper += (long)((24 - this.tickmax) / 2);
                            if (DangerZone.wr.fps < 40) {
                                sleeper += 16L;
                            }
                            if (DangerZone.wr.fps < 20) {
                                sleeper += 16L;
                            }
                            if (DangerZone.showcase || !DangerZone.light_speed) {
                                sleeper += 32L;
                            }
                            Thread.sleep(sleeper);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if (DangerZone.gameover != 0) {
                            return;
                        }
                        Coords cl = null;
                        while (true) {
                            requested_list_lock.lock();
                            Iterator<Coords> ii = requested_list.iterator();
                            cl = null;
                            if (ii.hasNext()) {
                                cl = ii.next();
                                ii.remove();
                            }
                            requested_list_lock.unlock();
                            if (cl == null) break;
                            LightingThread.updateLightMaps(DangerZone.world, cl.lv, cl.d, cl.x, cl.y, cl.z);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            if (!restart) continue;
            restart = false;
            requested_list_lock.lock();
            Iterator<Coords> ii = requested_list.iterator();
            while (ii.hasNext()) {
                ii.remove();
            }
            requested_list_lock.unlock();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void tickChunk(World w, int xrel, int zrel) {
        short[] leveldata = null;
        short[] lightmap = null;
        short[] drawn = null;
        boolean active = false;
        Player p = DangerZone.player;
        if (p == null) {
            return;
        }
        Chunk c = w.chunkcache.getDecoratedChunk(p.dimension, (xrel << 4) + (int)p.posx, 0, (zrel << 4) + (int)p.posz);
        if (c == null) {
            return;
        }
        drawn = c.drawn;
        if (drawn == null) {
            return;
        }
        int j = DangerZone.mindrawlevel;
        while (j < 256) {
            int idown;
            int iup;
            int k;
            int i;
            active = false;
            lightmap = w.chunkcache.getDecoratedChunkLightmap(p.dimension, c.chunkX << 4, j, c.chunkZ << 4);
            if (lightmap != null) {
                i = 0;
                while (i < 16) {
                    k = 0;
                    while (k < 16) {
                        if (lightmap[i * 16 + k] > 19) {
                            int n = i * 16 + k;
                            lightmap[n] = (short)(lightmap[n] - 20);
                            if (lightmap[i * 16 + k] > 19) {
                                active = true;
                            }
                        } else if (lightmap[i * 16 + k] < -19) {
                            int n = i * 16 + k;
                            lightmap[n] = (short)(lightmap[n] + 20);
                            if (lightmap[i * 16 + k] < -19) {
                                active = true;
                            }
                        } else {
                            lightmap[i * 16 + k] = 0;
                        }
                        ++k;
                    }
                    ++i;
                }
                if (!active) {
                    w.chunkcache.clearDecoratedChunkLightmap(p.dimension, c.chunkX << 4, j, c.chunkZ << 4);
                    lightmap = null;
                }
            }
            if ((iup = j + 1) > 255) {
                iup = 255;
            }
            if ((idown = j - 1) < 0) {
                idown = 0;
            }
            if ((drawn == null || drawn[j] != 0 || drawn[iup] != 0 || drawn[idown] != 0) && (leveldata = c.blockdata[j]) != null) {
                i = 0;
                while (i < 16) {
                    k = 0;
                    while (k < 16) {
                        float currentlight;
                        short bid = leveldata[i * 16 + k];
                        if (bid != 0 && (currentlight = Blocks.getLightLevel(bid, w, p.dimension, (c.chunkX << 4) + i, j, (c.chunkZ << 4) + k)) != 0.0f) {
                            LightingThread.updateLightMaps(w, currentlight, p.dimension, (c.chunkX << 4) + i, j, (c.chunkZ << 4) + k);
                        }
                        ++k;
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    public static void updateLightMaps(World w, float lv, int d, int x, int y, int z) {
        int updist = 14;
        float newv = 0.0f;
        if (DangerZone.renderdistance <= 20) {
            updist = 12;
        }
        if (DangerZone.renderdistance <= 16) {
            updist = 10;
        }
        if (DangerZone.renderdistance <= 12) {
            updist = 8;
        }
        if (DangerZone.renderdistance < 10) {
            updist = 6;
        }
        int j = -updist;
        while (j <= updist) {
            if (y + j >= 0 && y + j <= 255) {
                int i = -updist;
                while (i <= updist) {
                    int k = -updist;
                    while (k <= updist) {
                        float cdist = (float)Math.sqrt(i * i + j * j + k * k);
                        if (cdist < (float)updist) {
                            float cval = lv * ((float)updist - cdist) / (float)updist;
                            float prev = LightingThread.getLightMapValue(w, d, x + i, y + j, z + k);
                            if (prev >= 0.0f && cval > 0.0f) {
                                newv = prev;
                                if (cval > newv) {
                                    newv = cval;
                                }
                            } else if (prev <= 0.0f && cval < 0.0f) {
                                newv = prev;
                                if (cval < newv) {
                                    newv = cval;
                                }
                            } else {
                                newv = prev + cval * cval * Math.signum(cval);
                            }
                            w.chunkcache.setDecoratedChunkLightValue(d, x + i, y + j, z + k, newv);
                        }
                        ++k;
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    public static float getLightMapValue(World w, int d, int x, int y, int z) {
        short[] lightmap = w.chunkcache.getDecoratedChunkLightmap(d, x, y, z);
        if (lightmap == null) {
            return 0.0f;
        }
        float tmp = lightmap[(x & 0xF) * 16 + (z & 0xF)];
        return tmp / 1000.0f;
    }

    public static void addRequest(int d, int x, int y, int z, float val) {
        if (requested_list == null) {
            return;
        }
        requested_list_lock.lock();
        if (requested_list.size() > 200) {
            requested_list_lock.unlock();
            return;
        }
        for (Coords c : requested_list) {
            if (c.d != d || c.x != x || c.z != z || c.y != y || c.lv != val) continue;
            requested_list_lock.unlock();
            return;
        }
        Coords newc = new Coords();
        newc.d = d;
        newc.x = x;
        newc.y = y;
        newc.z = z;
        newc.lv = val;
        requested_list.add(newc);
        requested_list_lock.unlock();
    }
}

